@extends('admin.layout.template')
@section('title', 'Project Details')
@section('content')

<div class="page-content">
    <div class="container-xxl">

        {{-- ================= PROJECT HEADER ================= --}}
        <div class="card mb-4 shadow-sm">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-start">

                    {{-- LEFT SIDE --}}
                    <div>
                        <h3 class="mb-2">
                            {{ $project->project_name }}
                            <span class="badge bg-info ms-2">
                                {{ $project->project_number }}
                            </span>
                        </h3>

                        <div class="row mt-3">
                            <div class="col-md-6">
                                <p class="mb-1">
                                    <strong>Customer :</strong>
                                    {{ $project->customer_name }}
                                </p>
                                <p class="mb-1">
                                    <strong>Phone :</strong>
                                    {{ $project->customer_phone }}
                                </p>
                                <p class="mb-1">
                                    <strong>Address :</strong>
                                    {{ $project->address }}
                                </p>
                            </div>

                            <div class="col-md-6">
                                <p class="mb-1">
                                    <strong>Project Type :</strong>
                                    {{ $project->project_type ?? '-' }}
                                </p>

                                <p class="mb-1">
                                    <strong>Expected Completion :</strong>
                                    {{ $project->expected_completion_date 
                                ? \Carbon\Carbon::parse($project->expected_completion_date)->format('d M Y') 
                                : '-' }}
                                </p>

                                <p class="mb-1">
                                    <strong>Status :</strong>
                                    <span class="badge 
                                @if($project->status == 'completed') bg-success
                                @elseif($project->status == 'pending') bg-warning
                                @else bg-secondary
                                @endif">
                                        {{ ucfirst($project->status) }}
                                    </span>
                                </p>
                            </div>
                        </div>
                    </div>

                    {{-- RIGHT SIDE --}}
                    <div class="text-end">

                        <p class="mb-1">
                            <strong>Employee :</strong>
                            {{ $project->employee_name ?? '-' }}
                        </p>

                        <p class="mb-3">
                            <strong>Contact :</strong>
                            {{ $project->employee_contact ?? '-' }}
                        </p>

                        {{-- PDF Buttons --}}
                        <div class="d-flex justify-content-end align-items-center gap-2 flex-wrap">

                            {{-- Upload / Update --}}
                            <!-- <button class="btn btn-dark btn-sm px-3"
                                data-bs-toggle="modal"
                                data-bs-target="#quotationModal">
                                <i class="bi bi-upload"></i>
                                {{ $project->quotation_pdf ? 'Update Quotation' : 'Upload Quotation' }}
                            </button>

                            {{-- View Quotation (if exists) --}}
                            @if($project->quotation_pdf)
                            <a href="{{ asset($project->quotation_pdf) }}"
                                target="_blank"
                                class="btn btn-success btn-sm px-3">
                                <i class="bi bi-eye"></i> View
                            </a>
                            @endif

                            -->
                            <button class="btn btn-dark btn-sm px-3"
                                data-bs-toggle="modal"
                                data-bs-target="#editProjectModal">
                                <i class="bi bi-pencil"></i> Edit Project
                            </button>
                            {{-- More Actions Dropdown --}}
                            <div class="dropdown">
                                <button class="btn btn-outline-secondary btn-sm dropdown-toggle"
                                    data-bs-toggle="dropdown">
                                    More PDFs
                                </button>

                                <ul class="dropdown-menu dropdown-menu-end shadow">
                                    <li>
                                        <a class="dropdown-item"
                                            href="{{ url('/api/pdf/measurement/'.$project->id) }}"
                                            target="_blank">
                                            Measurement PDF
                                        </a>
                                    </li>

                                    <li>
                                        <a class="dropdown-item"
                                            href="{{ url('/api/pdf/invoice/'.$project->id) }}"
                                            target="_blank">
                                            Invoice PDF
                                        </a>
                                    </li>
                                    <li>
                                        <a class="dropdown-item"
                                            href="{{ url('/api/pdf/quotation/'.$project->id) }}"
                                            target="_blank">
                                            Client Quotation
                                        </a>
                                    </li>
                                </ul>
                            </div>

                        </div>

                    </div>

                </div>
            </div>
        </div>

        <div class="row mb-2">
            <div class="col-md-2">
                <div class="card text-center shadow-sm">
                    <div class="card-body">
                        <h6>Subtotal</h6>
                        <h4 class="text-primary">
                            ₹ {{ number_format($project->subtotal, 2) }}
                        </h4>
                    </div>
                </div>
            </div>

            <div class="col-md-2">
                <div class="card text-center shadow-sm">
                    <div class="card-body">
                        <h6>GST (18%)</h6>
                        <h4 class="text-warning">
                            ₹ {{ number_format($project->tax, 2) }}
                        </h4>
                    </div>
                </div>
            </div>

            <div class="col-md-2">
                <div class="card text-center shadow-sm">
                    <div class="card-body">
                        <h6>Grand Total</h6>
                        <h4 class="text-success">
                            ₹ {{ number_format($project->grand_total, 2) }}
                        </h4>
                    </div>
                </div>
            </div>
            <!-- </div> -->

            {{-- ================= PROJECT SUMMARY ================= --}}
            <!-- <div class="row mb-2"> -->
            <div class="col-md-2">
                <div class="card text-center">
                    <div class="card-body">
                        <h6>Total Areas</h6>
                        <h4 class="text-info">{{ $project->areas->count() }}</h4>
                    </div>
                </div>
            </div>

            <div class="col-md-2">
                <div class="card text-center">
                    <div class="card-body">
                        <h6>Total Items</h6>
                        <h4 class="text-primary">
                            {{ $project->areas->sum(fn($area) => $area->items->count()) }}
                        </h4>
                    </div>
                </div>
            </div>

            <div class="col-md-2">
                <div class="card text-center">
                    <div class="card-body">
                        <h6>Total Amount Entered</h6>
                        <h4 class="text-success"> {{ $project->total_amount }}</h4>
                    </div>
                </div>
            </div>
        </div>



        {{-- ================= AREAS LOOP ================= --}}
        @foreach($project->areas as $area)

        <div class="card mb-4">
            <div class="card-header bg-light">
                <h5 class="mb-0">
                    Area: {{ $area->name }}
                    @if($area->room)
                    <span class="text-muted">
                        (Room: {{ $area->room->name }})
                    </span>
                    @endif
                </h5>
            </div>

            <div class="card-body">

                @if($area->items->count() > 0)

                <div class="table-responsive">
                    <table class="table table-bordered align-middle table-sm">
                        <thead class="table-light">
                            <tr>
                                <th width="4%">#</th>
                                <th width="8%">Image</th>
                                <th width="12%">Product</th>
                                <th width="8%">Type</th>
                                <th width="8%">Unit</th>
                                <th width="8%">Qty</th>
                                <th width="12%">Size</th>
                                <th width="12%">Room</th>
                                <th width="10%">Item</th>
                                <th width="12%">Catalog</th>
                                <th width="10%">Serial</th>
                                <th>Description</th>
                            </tr>
                        </thead>


                        <tbody>
                            @foreach($area->items as $index => $item)

                            @php
                            $unit = 'Nos';
                            $qty = 1;

                            // ===============================
                            // NON CUSTOM
                            // ===============================
                            if($item->is_custom == 0){

                            $qty = (float) ($item->quantity ?? 1);

                            if($item->category == 'curtain'){
                            $unit = 'Pcs';
                            }
                            elseif($item->category == 'wallpaper'){
                            $unit = 'Rolls';
                            }

                            }
                            // ===============================
                            // CUSTOM CURTAIN
                            // ===============================
                            elseif($item->category == 'curtain' && $item->curtain && $item->measurement){

                            $fw = (float) $item->curtain->fabric_width;
                            $ww = (float) $item->measurement->width;
                            $wh = (float) $item->measurement->height;

                            if($fw > 0){
                            $panels = ceil($ww / $fw);
                            $qty = $panels * $wh;
                            }

                            $unit = 'Meter';
                            }
                            // ===============================
                            // CUSTOM WALLPAPER
                            // ===============================
                            elseif($item->category == 'wallpaper' && $item->wallpaper){

                            $rw = (float) $item->wallpaper->roll_width;
                            $rl = (float) $item->wallpaper->roll_length;
                            $ww = (float) $item->wallpaper->wall_width;
                            $wh = (float) $item->wallpaper->wall_height;
                            $rep = (float) ($item->wallpaper->design_repeat ?? 0);

                            if($rw > 0 && $rl > 0){
                            $cuttings = ceil($ww / $rw);
                            $totalLength = $cuttings * ($wh + $rep);
                            $qty = ceil($totalLength / $rl);
                            }

                            $unit = 'Rolls';
                            }
                            @endphp

                            <tr>

                                {{-- SL --}}
                                <td>{{ $index + 1 }}</td>

                                {{-- IMAGE --}}
                                <td>
                                    @if($item->is_custom == 0 && $item->variant?->primaryImage?->image_path)
                                    <img src="{{ asset($item->variant->primaryImage->image_path) }}" width="60">
                                    @else
                                    <span class="text-muted">Custom</span>
                                    @endif
                                </td>

                                {{-- PRODUCT --}}
                                <td>
                                    {{ $item->product->name ?? 'Custom Item' }}
                                </td>

                                {{-- TYPE (is_custom badge) --}}
                                <td>
                                    @if($item->is_custom == 1)
                                    <span class="badge bg-warning text-dark">Custom</span>
                                    @else
                                    <span class="badge bg-success">Standard</span>
                                    @endif
                                </td>

                                {{-- UNIT --}}
                                <td>{{ $unit }}</td>

                                {{-- QTY --}}
                                <td>{{ $qty > 0 ? number_format($qty,2) : '-' }}</td>

                                {{-- SIZE --}}
                                <td>
                                    @if($item->measurement)
                                    {{ $item->measurement->width ?? '-' }}
                                    x
                                    {{ $item->measurement->height ?? '-' }}
                                    {{ $item->measurement->unit ?? '' }}
                                    @else
                                    -
                                    @endif
                                </td>

                                {{-- ROOM --}}
                                <td>{{ $area->area_name ?? $area->name ?? '-' }}</td>

                                {{-- CATEGORY --}}
                                <td>{{ ucfirst($item->category ?? '-') }}</td>

                                {{-- CATALOG --}}
                                <td>
                                    {{
            $item->curtain->catalogue ??
            $item->wallpaper->catalogue ??
            '-'
        }}
                                </td>

                                {{-- SERIAL --}}
                                <td>
                                    {{
            $item->curtain->serial_no ??
            $item->wallpaper->serial_no ??
            '-'
        }}
                                </td>

                                {{-- DESCRIPTION --}}
                                <td>{{ $item->notes ?? '-' }}</td>

                            </tr>

                            @endforeach

                        </tbody>
                    </table>
                </div>


                @else
                <p class="text-muted">No items found in this area.</p>
                @endif

            </div>
        </div>

        @endforeach


        <a href="{{ route('projects.index') }}" class="btn btn-secondary mt-3">Back to Projects</a>

    </div>
</div>

<!-- Quotation Upload Modal -->
<div class="modal fade" id="quotationModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">

            <form action="{{ route('projects.upload.quotation', $project->id) }}"
                method="POST"
                enctype="multipart/form-data">

                @csrf

                <div class="modal-header">
                    <h5 class="modal-title">
                        {{ $project->quotation_pdf ? 'Update' : 'Upload' }} Quotation PDF
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">

                    <div class="mb-3">
                        <label class="form-label">Select PDF File</label>
                        <input type="file"
                            name="quotation_pdf"
                            class="form-control"
                            accept="application/pdf"
                            required>
                        <small class="text-muted">
                            Max size: 4MB
                        </small>
                    </div>

                    @if($project->quotation_pdf)
                    <p>
                        Current File:
                        <a href="{{ asset($project->quotation_pdf) }}"
                            target="_blank">
                            View PDF
                        </a>
                    </p>
                    @endif

                </div>

                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">
                        {{ $project->quotation_pdf ? 'Update' : 'Upload' }}
                    </button>
                    <button type="button" class="btn btn-secondary"
                        data-bs-dismiss="modal">
                        Cancel
                    </button>
                </div>

            </form>

        </div>
    </div>
</div>



<div class="modal fade" id="editProjectModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">

            <form id="editProjectForm">
                @csrf
                <input type="hidden" name="project_id" value="{{ $project->id }}">


                <div class="modal-header">
                    <h5 class="modal-title">Edit Project</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">

                    <div class="row">

                        <div class="col-md-6 mb-3">
                            <label>Project Name</label>
                            <input type="text" name="project_name"
                                class="form-control"
                                value="{{ $project->project_name }}" required>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label>Project Type</label>
                            <input type="text" name="project_type"
                                class="form-control"
                                value="{{ $project->project_type }}">
                        </div>

                        <div class="col-md-6 mb-3">
                            <label>Customer Name</label>
                            <input type="text" name="customer_name"
                                class="form-control"
                                value="{{ $project->customer_name }}" required>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label>Customer Phone</label>
                            <input type="text" name="customer_phone"
                                class="form-control"
                                value="{{ $project->customer_phone }}">
                        </div>

                        <div class="col-md-12 mb-3">
                            <label>Address</label>
                            <textarea name="address"
                                class="form-control"
                                rows="2">{{ $project->address }}</textarea>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label>Expected Completion</label>
                            <input type="date" name="expected_completion_date"
                                class="form-control"
                                value="{{ $project->expected_completion_date }}">
                        </div>

                        <div class="col-md-6 mb-3">
                            <label>Status</label>
                            <select name="status" class="form-select" required>
                                @php
                                $statuses = ['new','measuring','quoted','approved','production','completed'];
                                @endphp

                                @foreach($statuses as $status)
                                <option value="{{ $status }}"
                                    {{ $project->status == $status ? 'selected' : '' }}>
                                    {{ ucfirst($status) }}
                                </option>
                                @endforeach
                            </select>
                        </div>

                        <div class="col-md-4 mb-3">
                            <label>Employee Name</label>
                            <input type="text" name="employee_name"
                                class="form-control"
                                value="{{ $project->employee_name }}">
                        </div>

                        <div class="col-md-4 mb-3">
                            <label>Employee Contact</label>
                            <input type="text" name="employee_contact"
                                class="form-control"
                                value="{{ $project->employee_contact }}">
                        </div>

                        <div class="col-md-4 mb-3">
                            <label>Total Amount</label>
                            <input type="number" step="0.01"
                                name="total_amount"
                                class="form-control"
                                value="{{ $project->total_amount }}">
                        </div>

                    </div>

                </div>

                <div class="modal-footer">
                    <button type="submit" class="btn btn-success">Update Project</button>
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                </div>

            </form>

        </div>
    </div>
</div>


<div class="modal fade" id="editItemModal" tabindex="-1">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">

            <form id="editItemForm">
                @csrf
                <input type="hidden" name="project_item_id" id="edit_project_item_id">

                <div class="modal-header">
                    <h5>Edit Item</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>

                <div class="modal-body">

                    <div class="row">

                        {{-- CATEGORY --}}
                        <div class="col-md-3 mb-3">
                            <label>Category</label>
                            <select name="category" id="edit_category" class="form-select">
                                <option value="">Select</option>
                                <option value="curtain">Curtain</option>
                                <option value="mattress">Mattress</option>
                                <option value="sofa">Sofa</option>
                                <option value="wallpaper">Wallpaper</option>
                                <option value="fabric">Fabric</option>
                                <option value="accessories">Accessories</option>
                            </select>
                        </div>

                        {{-- SUBCATEGORY --}}
                        <div class="col-md-3 mb-3">
                            <label>Subcategory</label>
                            <select name="subcategory_id" id="edit_subcategory" class="form-select"></select>
                        </div>

                        {{-- CATALOGUE --}}
                        <div class="col-md-3 mb-3">
                            <label>Catalogue</label>
                            <select name="product_id" id="edit_catalogue" class="form-select"></select>
                        </div>

                        {{-- SKU --}}
                        <div class="col-md-3 mb-3">
                            <label>SKU</label>
                            <select name="variant_id" id="edit_sku" class="form-select"></select>
                        </div>

                    </div>

                    <hr>

                    {{-- ================= CURTAIN FIELDS ================= --}}
                    <div id="curtain_section" class="category_section d-none">
                        <div class="row">

                            <div class="col-md-3">
                                <label>Width</label>
                                <input type="number" name="measurement[width]" class="form-control">
                            </div>

                            <div class="col-md-3">
                                <label>Height</label>
                                <input type="number" name="measurement[height]" class="form-control">
                            </div>

                            <div class="col-md-2">
                                <label>Unit</label>
                                <select name="measurement[unit]" class="form-select">
                                    <option value="cm">CM</option>
                                    <option value="inch">Inch</option>
                                </select>
                            </div>

                            <div class="col-md-2">
                                <label>Motorized</label>
                                <select name="details[motorized]" class="form-select">
                                    <option value="0">No</option>
                                    <option value="1">Yes</option>
                                </select>
                            </div>

                            <div class="col-md-3">
                                <label>Model</label>
                                <select name="details[model]" id="edit_model" class="form-select"></select>
                            </div>

                            <div class="col-md-3">
                                <label>Catalogue</label>
                                <input type="text" name="details[catalogue]" class="form-control">
                            </div>

                            <div class="col-md-3">
                                <label>Serial No</label>
                                <input type="text" name="details[serial_no]" class="form-control">
                            </div>

                        </div>
                    </div>

                    {{-- ================= MATTRESS SECTION ================= --}}
                    <div id="mattress_section" class="category_section d-none">
                        <div class="row">

                            <div class="col-md-3">
                                <label>Type</label>
                                <select name="details[type]" id="mattress_type" class="form-select"></select>
                            </div>

                            <div class="col-md-3">
                                <label>Thickness</label>
                                <select name="details[thickness]" id="mattress_thickness" class="form-select"></select>
                            </div>

                            <div class="col-md-3">
                                <label>Size</label>
                                <select name="details[size]" id="mattress_size" class="form-select"></select>
                            </div>

                            <div class="col-md-2">
                                <label>Unit</label>
                                <select name="details[unit]" class="form-select">
                                    <option value="inch">Inch</option>
                                    <option value="ft">Ft</option>
                                    <option value="cm">CM</option>
                                </select>
                            </div>

                        </div>
                    </div>

                    {{-- ================= WALLPAPER SECTION ================= --}}
                    <div id="wallpaper_section" class="category_section d-none">
                        <div class="row">

                            <div class="col-md-3">
                                <label>Wall Width</label>
                                <input type="number" name="measurement[width]" class="form-control">
                            </div>

                            <div class="col-md-3">
                                <label>Wall Height</label>
                                <input type="number" name="measurement[height]" class="form-control">
                            </div>

                            <div class="col-md-3">
                                <label>Roll Qty</label>
                                <input type="number" name="details[roll_quantity]" class="form-control">
                            </div>

                            <div class="col-md-3">
                                <label>Catalogue</label>
                                <input type="text" name="details[catalogue]" class="form-control">
                            </div>

                            <div class="col-md-3">
                                <label>Serial</label>
                                <input type="text" name="details[serial_no]" class="form-control">
                            </div>

                        </div>
                    </div>

                    {{-- COMMON --}}
                    <div class="row mt-3">
                        <div class="col-md-2">
                            <label>Quantity</label>
                            <input type="number" name="quantity" class="form-control">
                        </div>

                        <div class="col-md-6">
                            <label>Note</label>
                            <input type="text" name="note" class="form-control">
                        </div>
                    </div>

                </div>

                <div class="modal-footer">
                    <button type="submit" class="btn btn-success">Update Item</button>
                </div>

            </form>
        </div>
    </div>
</div>



<script>
    $('#editProjectForm').on('submit', function(e) {
        e.preventDefault();

        let form = $(this);
        let formData = form.serialize();

        Swal.fire({
            title: 'Are you sure?',
            text: "Do you want to update this project?",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Yes, Update!'
        }).then((result) => {

            if (result.isConfirmed) {

                $.ajax({
                    url: "{{ route('projects.update') }}",
                    type: "POST",
                    data: formData,
                    success: function(res) {

                        if (res.status) {

                            Swal.fire(
                                'Updated!',
                                res.message,
                                'success'
                            );

                            // Update header values without reload
                            $('h3.mb-2').html(
                                res.project.project_name +
                                ' <span class="badge bg-info ms-2">' +
                                '{{ $project->project_number }}' +
                                '</span>'
                            );

                            $('#editProjectModal').modal('hide');

                        } else {
                            Swal.fire('Error!', res.message, 'error');
                        }
                    },
                    error: function(xhr) {
                        Swal.fire('Error!', 'Something went wrong.', 'error');
                    }
                });

            }
        });
    });


    $('#edit_category').on('change', function() {

        let category = $(this).val();

        // hide all
        $('.category_section').addClass('d-none');

        // show selected
        $('#' + category + '_section').removeClass('d-none');

        // call backend
        $.get('/config/category/' + category, function(res) {

            if (res.status) {

                // MODELS
                $('#edit_model').empty();
                res.models.forEach(function(model) {
                    $('#edit_model').append(`<option value="${model}">${model}</option>`);
                });

                // SUBCATEGORIES
                $('#edit_subcategory').empty();
                res.subcategories.forEach(function(sub) {
                    $('#edit_subcategory').append(`<option value="${sub.id}">${sub.name}</option>`);
                });

                // CATALOGUES
                $('#edit_catalogue').empty();
                res.catalogues.forEach(function(cat) {
                    $('#edit_catalogue').append(`<option value="${cat.product_id}">
${cat.catalogue} (${cat.product_name})
</option>`);
                });

            }

        });
    });

    $('#edit_catalogue').on('change', function() {

        let product_id = $(this).val();

        $.get('/config/catalogue-skus/' + product_id, function(res) {

            if (res.status) {

                // SKU
                $('#edit_sku').empty();

                res.skus.forEach(function(sku) {
                    $('#edit_sku').append(`
<option value="${sku.variant_id}">
${sku.sku} | ₹${sku.offer_price}
</option>`);
                });

                // Mattress Config
                if (res.mattress_config) {
                    let config = res.mattress_config;

                    // categories
                    $('#mattress_type').empty();
                    config.categories.forEach(function(c) {
                        $('#mattress_type').append(`<option value="${c}">${c}</option>`);
                    });

                    // thickness
                    $('#mattress_thickness').empty();
                    config.thickness.forEach(function(t) {
                        $('#mattress_thickness').append(`<option value="${t}">${t}</option>`);
                    });
                }

            }

        });

    });
</script>
@endsection